/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.lotr.recipes.internal.recipeHandlers;

import craftedMods.lotr.recipes.api.utils.LOTRRecipeHandlerUtils;
import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeHandlerRecipeViewer;
import craftedMods.recipes.api.RecipeHandlerRenderer;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.api.RegisteredHandler;
import craftedMods.recipes.api.utils.RecipeHandlerRendererUtils;
import craftedMods.recipes.api.utils.RecipeHandlerUtils;
import craftedMods.recipes.base.AbstractMTRecipeHandler;
import craftedMods.recipes.base.AbstractRecipeViewer;
import craftedMods.recipes.base.ShapelessRecipe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lotr.client.gui.LOTRGuiMillstone;
import lotr.common.LOTRMod;
import lotr.common.recipe.LOTRMillstoneRecipes;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

@RegisteredHandler
public class MillstoneRecipeHandler
extends AbstractMTRecipeHandler<MillstoneRecipe> {
    private final MillstoneRecipeHandlerRenderer renderer = new MillstoneRecipeHandlerRenderer();
    private final MillstoneRecipeHandlerRecipeViewer recipeViewer = new MillstoneRecipeHandlerRecipeViewer(this);

    public MillstoneRecipeHandler() {
        super("lotr.millstone");
    }

    public String getDisplayName() {
        return LOTRMod.millstone.func_149732_F();
    }

    public Collection<MillstoneRecipe> loadRecipes() {
        ArrayList<MillstoneRecipe> ret = new ArrayList<MillstoneRecipe>();
        try {
            Field millstoneRecipesField = LOTRMillstoneRecipes.class.getDeclaredField("recipeList");
            millstoneRecipesField.setAccessible(true);
            Map recipes = (Map)millstoneRecipesField.get(null);
            recipes.forEach((ingredient, result) -> ret.add(new MillstoneRecipe((ItemStack)ingredient, result.resultItem, result.chance)));
        }
        catch (Exception e) {
            this.logger.error("Couldn't access the field \"recipes\" in LOTRMillstoneRecipes", (Throwable)e);
        }
        return ret;
    }

    public List<RecipeItemSlot> getSlotsForRecipeItems(MillstoneRecipe recipe, EnumRecipeItemRole role) {
        return Arrays.asList(role == EnumRecipeItemRole.INGREDIENT ? this.createRecipeItemSlot(75, 16) : this.createRecipeItemSlot(75, 62));
    }

    public MillstoneRecipeHandlerRenderer getRenderer() {
        return this.renderer;
    }

    public int getRecipesPerPage() {
        return 1;
    }

    public RecipeHandlerRecipeViewer<MillstoneRecipe> getRecipeViewer() {
        return this.recipeViewer;
    }

    protected boolean isMineTweakerSupportEnabled() {
        return RecipeHandlerUtils.getInstance().hasMineTweaker() && LOTRRecipeHandlerUtils.hasMtLotr();
    }

    public int getDefaultOrder() {
        return 5000;
    }

    public class MillstoneRecipeHandlerRecipeViewer
    extends AbstractRecipeViewer<MillstoneRecipe, MillstoneRecipeHandler> {
        private final Collection<Class<? extends GuiContainer>> supportedGuiClasses;

        public MillstoneRecipeHandlerRecipeViewer(MillstoneRecipeHandler handler) {
            super((RecipeHandler)handler);
            this.supportedGuiClasses = new ArrayList<Class<? extends GuiContainer>>();
            this.supportedGuiClasses.addAll(AbstractRecipeViewer.RECIPE_HANDLER_GUIS);
            this.supportedGuiClasses.add(LOTRGuiMillstone.class);
        }

        public Collection<Class<? extends GuiContainer>> getSupportedGUIClasses() {
            return this.supportedGuiClasses;
        }

        public Collection<MillstoneRecipe> getAllRecipes() {
            return ((MillstoneRecipeHandler)this.handler).isMineTweakerSupportEnabled() ? ((MillstoneRecipeHandler)this.handler).loadRecipes() : ((MillstoneRecipeHandler)this.handler).getStaticRecipes();
        }

        public int getOffsetX(Class<? extends GuiContainer> guiClass) {
            return guiClass == LOTRGuiMillstone.class ? 36 : 9;
        }

        public int getOffsetY(Class<? extends GuiContainer> guiClass) {
            return guiClass == LOTRGuiMillstone.class ? 11 : 13;
        }
    }

    public class MillstoneRecipeHandlerRenderer
    implements RecipeHandlerRenderer<MillstoneRecipeHandler, MillstoneRecipe> {
        public void renderBackground(MillstoneRecipeHandler handler, MillstoneRecipe recipe, int cycleticks) {
            RecipeHandlerRendererUtils.getInstance().bindTexture("lotr:gui/millstone.png");
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(70, 15, 79, 24, 26, 68);
            RecipeHandlerRendererUtils.getInstance().drawProgressBar(76, 38, 176, 0, 14, 32, (float)(cycleticks % 48) / 48.0f, RecipeHandlerRendererUtils.EnumProgressBarDirection.INCREASE_DOWN);
        }

        public void renderForeground(MillstoneRecipeHandler handler, MillstoneRecipe recipe, int cycleticks) {
            String text = StatCollector.func_74837_a((String)"neiLotr.handler.millstone.chanceLabel", (Object[])new Object[]{Float.valueOf(recipe.getChance() * 100.0f)});
            RecipeHandlerRendererUtils.getInstance().drawTextCentered(text, 48 + RecipeHandlerRendererUtils.getInstance().getStringWidth(text) / 2, 95, 0x404040, false);
        }
    }

    public class MillstoneRecipe
    extends ShapelessRecipe {
        private final float chance;

        public MillstoneRecipe(ItemStack ingredient, ItemStack result, float chance) {
            super((Object)ingredient, result);
            this.chance = chance;
        }

        public float getChance() {
            return this.chance;
        }
    }
}

